/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.forge;

import icyllis.modernui.ModernUI;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.forge.CenterFragment2;
import icyllis.modernui.mc.forge.Config;
import icyllis.modernui.mc.forge.LocalStorage;
import icyllis.modernui.mc.forge.ModernUIText;
import icyllis.modernui.mc.forge.MuiForgeApi;
import icyllis.modernui.mc.forge.Registration;
import icyllis.modernui.util.DataSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="modernui")
public final class ModernUIForge
extends ModernUIMod {
    private static final Map<String, IEventBus> sModEventBuses = new HashMap<String, IEventBus>();

    public ModernUIForge() {
        if (!FMLEnvironment.production) {
            ModernUIMod.sDevelopment = true;
            LOGGER.debug(MARKER, "Auto detected in FML development environment");
        } else if (ModernUI.class.getSigners() == null) {
            LOGGER.warn(MARKER, "Signature is missing");
        }
        if (ModList.get().isLoaded("tipthescales") && !ModernUIMod.sOptiFineLoaded) {
            LOGGER.fatal(MARKER, "Detected TipTheScales without OptiFine");
            ModernUIForge.warnSetup("You should remove TipTheScales, Modern UI already includes its features, and Modern UI is also compatible with OptiFine", new Object[0]);
        }
        if (ModList.get().isLoaded("reblured")) {
            LOGGER.fatal(MARKER, "Detected ReBlurred");
            ModernUIForge.warnSetup("You should remove ReBlurred, Modern UI already includes its features, and Modern UI has better performance than it", new Object[0]);
        }
        sLegendaryTooltipsLoaded = ModList.get().isLoaded("legendarytooltips");
        sUntranslatedItemsLoaded = ModList.get().isLoaded("untranslateditems");
        Config.initCommonConfig(spec -> ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, "ModernUI/common.toml"));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> Config.reloadCommon(event.getConfig()));
        LocalStorage.init();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Loader::init);
        if (ModernUIMod.sDevelopment) {
            ModList.get().forEachModContainer((modid, container) -> {
                String namespace;
                if (container instanceof FMLModContainer && !(namespace = container.getNamespace()).equals("forge")) {
                    sModEventBuses.put(namespace, ((FMLModContainer)container).getEventBus());
                }
            });
        }
        LOGGER.info(MARKER, "Initialized Modern UI");
    }

    public static void warnSetup(String key, Object ... args) {
        ModLoader.get().addWarning(new ModLoadingWarning(null, ModLoadingStage.SIDED_SETUP, key, args));
    }

    public static <E extends Event> boolean post(@Nullable String ns, @Nonnull E e) {
        if (ns == null) {
            boolean handled = false;
            for (IEventBus bus : sModEventBuses.values()) {
                handled |= bus.post(e);
            }
            return handled;
        }
        IEventBus bus = sModEventBuses.get(ns);
        return bus != null && bus.post(e);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client
    extends ModernUIClient {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Client() {
            Config.initClientConfig(spec -> ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec, "ModernUI/client.toml"));
            Config.initTextConfig(spec -> ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec, "ModernUI/text.toml"));
            FontResourceManager.getInstance();
            if (ModernUIMod.isTextEngineEnabled()) {
                ModernUIText.init();
                LOGGER.info(MARKER, "Initialized Modern UI text engine");
            }
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> Config.reloadAnyClient(event.getConfig()));
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, modsScreen) -> {
                DataSet args = new DataSet();
                args.putBoolean("navigateToPreferences", true);
                CenterFragment2 fragment = new CenterFragment2();
                fragment.setArguments(args);
                return MuiForgeApi.get().createScreen(fragment, null, (Screen)modsScreen);
            }));
            if (ModernUIMod.sDevelopment) {
                FMLJavaModLoadingContext.get().getModEventBus().register(Registration.ModClientDev.class);
            }
            LOGGER.info(MARKER, "Initialized Modern UI client");
        }

        @Override
        @Nonnull
        protected Locale onGetSelectedLocale() {
            LanguageManager languageManager;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && (languageManager = minecraft.m_91102_()) != null) {
                return languageManager.getJavaLocale();
            }
            return super.onGetSelectedLocale();
        }

        static {
            boolean bl = $assertionsDisabled = !ModernUIForge.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }
    }

    private static class Loader {
        private Loader() {
        }

        public static void init() {
            new Client();
        }
    }
}

